<?php

namespace App\Http\Controllers\SuperAdmin;

use App\Exports\SuperAdmin\TherapistCommunitysExport;
use App\Http\Controllers\Controller;
use App\Http\Requests\SuperAdmin\TherapistCommunitys\CreateRequest;
use App\Http\Requests\ImportRequest;
use App\Http\Requests\SuperAdmin\TherapistCommunitys\UpdateRequest;
use App\Imports\SuperAdmin\TherapistCommunitysImport;
use App\Http\Resources\Web\TherapistCommunitysResource;
use Inertia\Inertia;
use App\Models\TherapistCommunity;
use App\Models\PricingPlan;
use App\Models\TherapistCommunityCategory;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Facades\Excel;
use Session;

class TherapistCommunitysController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    /********* Initialize Permission based Middlewares  ***********/
    public function __construct()
    {
        $this->middleware('permission:therapist_community.index');
        $this->middleware('permission:therapist_community.add', ['only' => ['store']]);
        $this->middleware('permission:therapist_community.edit', ['only' => ['update']]);
        $this->middleware('permission:therapist_community.delete', ['only' => ['destroy']]);
        $this->middleware('permission:therapist_community.export', ['only' => ['export']]);
        $this->middleware('permission:therapist_community.import', ['only' => ['import']]);
    }
    /********* Getter For Pagination, Searching And Sorting  ***********/
    public function getter($req = null, $export = null)
    {
        if ($req != null) {
            $therapist_communitys =  TherapistCommunity::withAll();
            if ($req->trash && $req->trash == 'with') {
                $therapist_communitys =  $therapist_communitys->withTrashed();
            }
            if ($req->trash && $req->trash == 'only') {
                $therapist_communitys =  $therapist_communitys->onlyTrashed();
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $therapist_communitys = $therapist_communitys->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {

                $therapist_communitys = $therapist_communitys->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $therapist_communitys = $therapist_communitys->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $therapist_communitys = $therapist_communitys->OrderBy('is_approved', 'ASC');
            }
            if ($export != null) { // for export do not paginate
                $therapist_communitys = $therapist_communitys->get();
                return $therapist_communitys;
            }
            $therapist_communitys = $therapist_communitys->get();
            return $therapist_communitys;
        }
        $therapist_communitys = TherapistCommunity::withAll()->OrderBy('is_approved', 'ASC')->get();
        return $therapist_communitys;
    }


    /*********View All TherapistCommunitys  ***********/
    public function index(Request $request)
    {
        $therapist_communitys = $this->getter($request);
        return view('super_admins.therapist_communitys.index')->with('therapist_communitys', $therapist_communitys);
    }

    /*********View Create Form of TherapistCommunity  ***********/
    public function create()
    {

        $pricing_plans = PricingPlan::therapistCommunity()->get();
        $therapist_community_categories = TherapistCommunityCategory::active()->get();
        return view('super_admins.therapist_communitys.create', compact('pricing_plans', 'therapist_community_categories'));
    }

    /*********Store TherapistCommunity  ***********/
    public function store(CreateRequest $request)
    {
        $data = $request->all();
        try {
            DB::beginTransaction();
            if (!$request->is_active) {
                $data['is_active'] = 0;
            }
            if (!$request->is_featured) {
                $data['is_featured'] = 0;
            }
            $data['image'] = uploadCroppedFile($request, 'image', 'therapist_communitys');

            $therapist_community = TherapistCommunity::create($data);
            $user = User::where('email', $request->email)->first();
            if ($user) {
                $user->roles()->attach(['therapist_community']);
                $therapist_community->update(['user_id' => $user->id]);
            } else {
                $user = $therapist_community->user()->create([
                    'name' => $therapist_community->name,
                    'email' => $request->email,
                    'password' => Hash::make($request->password),
                ]);
                $user->markEmailAsVerified();
                $therapist_community->update(['user_id' => $user->id]);
                $user->roles()->attach(['therapist_community']);
            }
            $therapist_community->therapist_community_categories()->attach($request->therapist_community_category_ids);
            $therapist_community->save();
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->route('super_admin.therapist_communitys.index')->with('message', 'Something Went Wrong')->with('message_type', 'error');
        }
        return redirect()->route('super_admin.therapist_communitys.index')->with('message', 'TherapistCommunity Created Successfully')->with('message_type', 'success');
    }

    /*********View TherapistCommunity  ***********/
    public function show(TherapistCommunity $therapist_community)
    {
        return view('super_admins.therapist_communitys.show', compact('therapist_community'));
    }

    /*********View Edit Form of TherapistCommunity  ***********/
    public function edit(TherapistCommunity $therapist_community)
    {
        $therapist_community_categories = TherapistCommunityCategory::active()->get();
        $pricing_plans = PricingPlan::therapistCommunity()->get();
        return view('super_admins.therapist_communitys.edit', compact('therapist_community', 'pricing_plans', 'therapist_community_categories'));
    }

    /*********Update TherapistCommunity  ***********/
    public function update(UpdateRequest $request, TherapistCommunity $therapist_community)
    {
        $data = $request->all();
        try {
            DB::beginTransaction();
            if (!$request->is_active) {
                $data['is_active'] = 0;
            }
            if (!$request->is_featured) {
                $data['is_featured'] = 0;
            }
            if ($request->image) {
                $data['image'] = uploadCroppedFile($request, 'image', 'therapist_communitys', $therapist_community->image);
            } else {
                $data['image'] = $therapist_community->image;
            }
            if (isset($request->therapist_community_category_ids)) {
                $therapist_community->therapist_community_categories()->sync($request->therapist_community_category_ids);
            }
            $therapist_community->update($data);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->route('super_admin.therapist_communitys.index')->with('message', 'Something Went Wrong')->with('message_type', 'error');
        }
        return redirect()->route('super_admin.therapist_communitys.index')->with('message', 'TherapistCommunity Updated Successfully')->with('message_type', 'success');
    }

    /********* Export  CSV And Excel  **********/
    public function export(Request $request)
    {
        $therapist_communitys = $this->getter($request, "export");
        if (in_array($request->export, ['csv,xlsx'])) {
            $extension = $request->export;
        } else {
            $extension = 'xlsx';
        }
        $filename = "therapist_communitys." . $extension;
        return Excel::download(new TherapistCommunitysExport($therapist_communitys), $filename);
    }
    /********* Import CSV And Excel  **********/
    public function import(ImportRequest $request)
    {
        $file = $request->file('file');
        Excel::import(new TherapistCommunitysImport, $file);
        return redirect()->back()->with('message', 'Blog Categories imported Successfully')->with('message_type', 'success');
    }


    /*********Soft DELETE TherapistCommunity ***********/
    public function destroy(TherapistCommunity $therapist_community)
    {
        $therapist_community->delete();
        return redirect()->back()->with('message', 'TherapistCommunity Deleted Successfully')->with('message_type', 'success');
    }

    /*********Permanently DELETE TherapistCommunity ***********/
    public function destroyPermanently(Request $request, $therapist_community)
    {
        $therapist_community = TherapistCommunity::withTrashed()->find($therapist_community);
        if ($therapist_community) {
            if ($therapist_community->trashed()) {
                if ($therapist_community->image && file_exists(public_path($therapist_community->image))) {
                    unlink(public_path($therapist_community->image));
                }
                $therapist_community->forceDelete();
                return redirect()->back()->with('message', 'TherapistCommunity Deleted Successfully')->with('message_type', 'success');
            } else {
                return redirect()->back()->with('message', 'TherapistCommunity is Not in Trash')->with('message_type', 'error');
            }
        } else {
            return redirect()->back()->with('message', 'TherapistCommunity Not Found')->with('message_type', 'error');
        }
    }
    /********* Restore TherapistCommunity***********/
    public function restore(Request $request, $therapist_community)
    {
        $therapist_community = TherapistCommunity::withTrashed()->find($therapist_community);
        if ($therapist_community->trashed()) {
            $therapist_community->restore();
            return redirect()->back()->with('message', 'TherapistCommunity Restored Successfully')->with('message_type', 'success');
        } else {
            return redirect()->back()->with('message', 'TherapistCommunity Not Found')->with('message_type', 'error');
        }
    }
    /*********Approve TherapistCommunity ***********/
    public function approve(TherapistCommunity $therapist_community)
    {
        if (!$therapist_community->is_approved) {
            $therapist_community->update(['is_approved' => 1, 'approved_at' => now()]);
        }
        return redirect()->back()->with('message', 'TherapistCommunity Approved Successfully')->with('message_type', 'success');
    }


    public function profile(Request $request, $therapist_community)
    {
        $therapist_community = TherapistCommunity::withChildrens()->withAll()->where('id', $therapist_community)->first();
        if (!$therapist_community) {
            abort(404);
        }
        $therapist_community = new TherapistCommunitysResource($therapist_community);
        return Inertia::render('TherapistCommunitys/Profile', [
            'therapist_community' => $therapist_community
        ]);
    }

    public function bulkActionTherapistCommunitys(Request $request, $type)
    {
        if ($type == 'approve') {
            TherapistCommunity::whereIn('id', $request->selected_ids)->update([
                'is_approved' => 1
            ]);
        } elseif ($type == 'disapprove') {
            TherapistCommunity::whereIn('id', $request->selected_ids)->update([
                'is_approved' => 0
            ]);
        } elseif ($type == 'inactive') {
            TherapistCommunity::whereIn('id', $request->selected_ids)->update([
                'is_active' => 0
            ]);
        } elseif ($type == 'active') {
            TherapistCommunity::whereIn('id', $request->selected_ids)->update([
                'is_active' => 1
            ]);
        } elseif ($type == 'delete') {
            foreach ($request->selected_ids as $userId) {
                $business = TherapistCommunity::where('id', $userId)->first();
                $this->destroy($business);
            }
        } elseif ($type == 'feature') {
            TherapistCommunity::whereIn('id', $request->selected_ids)->update([
                'is_featured' => 1
            ]);
        } else {
            Session::flash('message', 'Some Thing Went Wrong !');
            return response()->json('Success', 200);
        }
        Session::flash('message', 'Updated Successfully');
        return response()->json('Success', 200);
    }
}
